<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] != 'employee') {
    header("Location: ../auth/login.php");
    exit;
}

include "../config/db.php";

$user_id   = $_SESSION['user']['id'];
$user_name = $_SESSION['user']['name'];
$team_name = isset($_SESSION['user']['team']) ? $_SESSION['user']['team'] : "";

// fetch all reports for this employee
$rq = mysqli_query($conn, "SELECT * FROM daily_reports WHERE user_id = $user_id ORDER BY report_date DESC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>My Reports - Employee</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <span class="navbar-brand">Daily Report</span>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarsExample">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarsExample">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <a href="dashboard.php" class="nav-link">Today</a>
        </li>
        <li class="nav-item">
          <a href="reports.php" class="nav-link active">My Reports</a>
        </li>
      </ul>
      <span class="navbar-text text-white me-3">
        <?php echo htmlspecialchars($team_name ?: ''); ?> <?php echo $team_name ? '-' : ''; ?> <?php echo htmlspecialchars($user_name); ?> (Employee)
      </span>
      <a href="logout.php" class="btn btn-outline-light btn-sm">Logout</a>
    </div>
  </div>
</nav>

<div class="container py-4">
  <h4 class="mb-3">My Reports (All Dates)</h4>

  <?php if (mysqli_num_rows($rq) == 0): ?>
    <div class="alert alert-info">No reports found yet.</div>
  <?php else: ?>
    <div class="table-responsive">
      <table class="table table-sm table-hover align-middle">
        <thead class="table-light">
          <tr>
            <th>Date</th>
            <th>Shift</th>
            <th>Total Worked Hours</th>
            <th>Tickets</th>
            <th>Chats</th>
            <th>Alerts</th>
            <th>Tasks</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
        <?php while ($rep = mysqli_fetch_assoc($rq)): ?>
          <?php
          $daily_id = $rep['id'];
          $counts = ['ticket' => 0, 'chat' => 0, 'alert' => 0, 'task' => 0];
          $cq = mysqli_query($conn, "SELECT task_type, COUNT(*) AS c FROM tasks WHERE daily_report_id = $daily_id GROUP BY task_type");
          while ($row = mysqli_fetch_assoc($cq)) {
              $counts[$row['task_type']] = $row['c'];
          }
          ?>
          <tr>
            <td><?php echo htmlspecialchars($rep['report_date']); ?></td>
            <td><?php echo ucfirst($rep['shift']); ?></td>
            <td><?php echo htmlspecialchars($rep['total_worked_hours']); ?></td>
            <td><?php echo $counts['ticket']; ?></td>
            <td><?php echo $counts['chat']; ?></td>
            <td><?php echo $counts['alert']; ?></td>
            <td><?php echo $counts['task']; ?></td>
            <td class="text-nowrap">
              <a href="dashboard.php?date=<?php echo urlencode($rep['report_date']); ?>" class="btn btn-sm btn-outline-primary">View</a>
              <a href="export_tasks.php?date=<?php echo urlencode($rep['report_date']); ?>" class="btn btn-sm btn-outline-success">Excel</a>
            </td>
          </tr>
        <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
