<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] != 'employee') {
    die("Unauthorized");
}

include "../config/db.php";

$user_id = $_SESSION['user']['id'];
$today   = date("Y-m-d");
$date    = isset($_GET['date']) && preg_match('/^\d{4}-\d{2}-\d{2}$/', $_GET['date']) ? $_GET['date'] : $today;

// find report
$q = mysqli_query($conn, "SELECT * FROM daily_reports WHERE user_id = $user_id AND report_date = '$date'");
$report = mysqli_fetch_assoc($q);
if (!$report) {
    die("No report for this date.");
}

$daily_id = $report['id'];

// get tasks
$tq = mysqli_query($conn, "SELECT * FROM tasks WHERE daily_report_id = $daily_id ORDER BY created_at ASC");

$filename = "report_" . $date . ".csv";

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="'.$filename.'"');

$output = fopen('php://output', 'w');

// header row
fputcsv($output, ['Date', 'Shift', 'Type', 'Client', 'Ticket ID', 'Description', 'Time Spent', 'Created At']);

while ($row = mysqli_fetch_assoc($tq)) {
    fputcsv($output, [
        $report['report_date'],
        $report['shift'],
        $row['task_type'],
        $row['client_name'],
        $row['ticket_id'],
        $row['description'],
        $row['time_spent'],
        $row['created_at']
    ]);
}

fclose($output);
exit;
?>
