<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] != 'employee') {
    header("Location: ../auth/login.php");
    exit;
}

include "../config/db.php";

$user_id   = $_SESSION['user']['id'];
$user_name = $_SESSION['user']['name'];
$team_name = isset($_SESSION['user']['team']) ? $_SESSION['user']['team'] : "";

// Get date (for history view) or default to today
$today = date("Y-m-d");
$date  = isset($_GET['date']) && preg_match('/^\d{4}-\d{2}-\d{2}$/', $_GET['date']) ? $_GET['date'] : $today;

// Fetch report for this user & date
$q = mysqli_query($conn, "SELECT * FROM daily_reports WHERE user_id = $user_id AND report_date = '$date'");
$report = mysqli_fetch_assoc($q);

// If no report and date is today -> ask shift selection
if (!$report && $date == $today) {
    header("Location: select_shift.php");
    exit;
}

// If no report and viewing past date
if (!$report) {
    $no_report = true;
} else {
    $no_report = false;
    $daily_id = $report['id'];
}

// Save/update total worked hours
if (!$no_report && isset($_POST['save_hours'])) {
    $hours = mysqli_real_escape_string($conn, $_POST['total_worked_hours']);
    mysqli_query($conn, "UPDATE daily_reports SET total_worked_hours = '$hours' WHERE id = $daily_id AND user_id = $user_id");
    $report['total_worked_hours'] = $hours;
}

// Fetch tasks for this report
$tickets = $chats = $alerts = $tasks = [];

if (!$no_report) {
    $tq = mysqli_query($conn, "SELECT * FROM tasks WHERE daily_report_id = $daily_id ORDER BY created_at ASC");
    while ($row = mysqli_fetch_assoc($tq)) {
        switch ($row['task_type']) {
            case 'ticket':
                $tickets[] = $row;
                break;
            case 'chat':
                $chats[] = $row;
                break;
            case 'alert':
                $alerts[] = $row;
                break;
            case 'task':
                $tasks[] = $row;
                break;
        }
    }
}

$totalHours = (!$no_report && !empty($report['total_worked_hours'])) ? $report['total_worked_hours'] : "";
?>
<!DOCTYPE html>
<html>
<head>
    <title>Employee Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <span class="navbar-brand">Daily Report</span>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarsExample">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarsExample">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <a href="dashboard.php" class="nav-link <?php echo ($date == $today) ? 'active' : ''; ?>">Today</a>
        </li>
        <li class="nav-item">
          <a href="reports.php" class="nav-link">My Reports</a>
        </li>
      </ul>
      <span class="navbar-text text-white me-3">
        <?php echo htmlspecialchars($team_name ?: ''); ?> <?php echo $team_name ? '-' : ''; ?> <?php echo htmlspecialchars($user_name); ?> (Employee)
      </span>
      <a href="logout.php" class="btn btn-outline-light btn-sm">Logout</a>
    </div>
  </div>
</nav>

<div class="container py-4">

  <div class="row mb-3">
    <div class="col-md-4">
      <div class="card shadow-sm">
        <div class="card-body">
          <h5 class="card-title mb-1">Date</h5>
          <p class="mb-0 text-muted"><?php echo htmlspecialchars($date); ?></p>
          <hr class="my-2">
          <p class="mb-0">
            Shift:
            <?php if ($no_report): ?>
              <span class="badge bg-secondary">No report</span>
            <?php else: ?>
              <span class="badge bg-primary"><?php echo ucfirst($report['shift']); ?></span>
            <?php endif; ?>
          </p>
        </div>
      </div>
    </div>

    <div class="col-md-4 mt-3 mt-md-0">
      <div class="card shadow-sm h-100">
        <div class="card-body d-flex flex-column justify-content-between">
          <div>
            <h5 class="card-title mb-2">Quick Actions</h5>
            <p class="text-muted small mb-2">Add tickets, chats/WhatsApp, alerts, or other tasks.</p>
          </div>
          <?php if (!$no_report): ?>
            <a href="add_task.php" class="btn btn-success w-100">+ Add Entry</a>
          <?php else: ?>
            <button class="btn btn-secondary w-100" disabled>No report for this date</button>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <div class="col-md-4 mt-3 mt-md-0">
      <div class="card shadow-sm h-100">
        <div class="card-body">
          <h6 class="card-title">Total Worked Hours</h6>
          <?php if (!$no_report): ?>
            <form method="POST" class="d-flex">
              <input type="text" name="total_worked_hours"
                     class="form-control form-control-sm me-2"
                     placeholder="5:05:00"
                     value="<?php echo htmlspecialchars($totalHours); ?>">
              <button type="submit" name="save_hours" class="btn btn-sm btn-primary">Save</button>
            </form>
            <small class="text-muted">Format: HH:MM:SS (applies to this date)</small>
          <?php else: ?>
            <p class="text-muted mb-0">No report for this date.</p>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>

  <?php if (!$no_report): ?>
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h5 class="mb-0">Entries for this shift</h5>
      <a href="export_tasks.php?date=<?php echo urlencode($date); ?>"
         class="btn btn-sm btn-outline-success">
        Export as Excel
      </a>
    </div>

    <!-- Tickets Section -->
    <div class="card shadow-sm mb-3">
      <div class="card-body">
        <h6 class="card-title mb-2">Tickets (<?php echo count($tickets); ?>)</h6>
        <?php if (count($tickets) == 0): ?>
          <p class="text-muted mb-0">No ticket entries.</p>
        <?php else: ?>
          <div class="table-responsive">
            <table class="table table-sm table-hover align-middle">
              <thead class="table-light">
                <tr>
                  <th>Time</th>
                  <th>Client</th>
                  <th>Ticket ID</th>
                  <th>Description</th>
                  <th>Time Spent</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($tickets as $row): ?>
                  <tr>
                    <td class="text-nowrap"><?php echo $row['created_at']; ?></td>
                    <td><?php echo htmlspecialchars($row['client_name']); ?></td>
                    <td><?php echo htmlspecialchars($row['ticket_id']); ?></td>
                    <td><?php echo nl2br(htmlspecialchars($row['description'])); ?></td>
                    <td><?php echo htmlspecialchars($row['time_spent']); ?></td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <!-- Chats / WhatsApp Section -->
    <div class="card shadow-sm mb-3">
      <div class="card-body">
        <h6 class="card-title mb-2">Chats / WhatsApp (<?php echo count($chats); ?>)</h6>
        <?php if (count($chats) == 0): ?>
          <p class="text-muted mb-0">No chat/WhatsApp entries.</p>
        <?php else: ?>
          <div class="table-responsive">
            <table class="table table-sm table-hover align-middle">
              <thead class="table-light">
                <tr>
                  <th>Time</th>
                  <th>Client</th>
                  <th>Description</th>
                  <th>Time Spent</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($chats as $row): ?>
                  <tr>
                    <td class="text-nowrap"><?php echo $row['created_at']; ?></td>
                    <td><?php echo htmlspecialchars($row['client_name']); ?></td>
                    <td><?php echo nl2br(htmlspecialchars($row['description'])); ?></td>
                    <td><?php echo htmlspecialchars($row['time_spent']); ?></td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <!-- Alerts Section -->
    <div class="card shadow-sm mb-3">
      <div class="card-body">
        <h6 class="card-title mb-2">Alerts (<?php echo count($alerts); ?>)</h6>
        <?php if (count($alerts) == 0): ?>
          <p class="text-muted mb-0">No alerts added.</p>
        <?php else: ?>
          <ul class="mb-0">
            <?php foreach ($alerts as $row): ?>
              <li><?php echo nl2br(htmlspecialchars($row['description'])); ?></li>
            <?php endforeach; ?>
          </ul>
        <?php endif; ?>
      </div>
    </div>

    <!-- Other Tasks Section -->
    <div class="card shadow-sm mb-3">
      <div class="card-body">
        <h6 class="card-title mb-2">Other Tasks (<?php echo count($tasks); ?>)</h6>
        <?php if (count($tasks) == 0): ?>
          <p class="text-muted mb-0">No other tasks.</p>
        <?php else: ?>
          <div class="table-responsive">
            <table class="table table-sm table-hover align-middle">
              <thead class="table-light">
                <tr>
                  <th>Time</th>
                  <th>Client / Context</th>
                  <th>Description</th>
                  <th>Time Spent</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($tasks as $row): ?>
                  <tr>
                    <td class="text-nowrap"><?php echo $row['created_at']; ?></td>
                    <td><?php echo htmlspecialchars($row['client_name']); ?></td>
                    <td><?php echo nl2br(htmlspecialchars($row['description'])); ?></td>
                    <td><?php echo htmlspecialchars($row['time_spent']); ?></td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>
    </div>

  <?php else: ?>

    <div class="alert alert-info">
      No report found for this date.
      <a href="dashboard.php" class="alert-link">Go to today</a>
    </div>

  <?php endif; ?>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
