<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] != 'admin') {
    header("Location: ../auth/login.php");
    exit;
}
include "../config/db.php";

$q = mysqli_query($conn, "
    SELECT t.*, u.name, dr.shift, dr.report_date
    FROM tasks t
    JOIN daily_reports dr ON t.daily_report_id = dr.id
    JOIN users u ON dr.user_id = u.id
    ORDER BY dr.report_date DESC, t.created_at DESC
");
?>
<!DOCTYPE html>
<html>
<head>
    <title>All Tasks - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <span class="navbar-brand">Daily Report - Admin</span>
    <div class="d-flex">
      <a href="dashboard.php" class="btn btn-outline-light btn-sm me-2">Dashboard</a>
      <a href="logout.php" class="btn btn-outline-light btn-sm">Logout</a>
    </div>
  </div>
</nav>

<div class="container py-4">
  <div class="card shadow-sm">
    <div class="card-body">
      <h4 class="card-title mb-3">All Employee Tasks</h4>

      <div class="table-responsive">
        <table class="table table-sm table-hover align-middle">
          <thead class="table-light">
            <tr>
              <th>Date</th>
              <th>Employee</th>
              <th>Shift</th>
              <th>Type</th>
              <th>Client</th>
              <th>Ticket ID</th>
              <th>Description</th>
              <th>Time Spent</th>
              <th>Created At</th>
            </tr>
          </thead>
          <tbody>
            <?php while ($row = mysqli_fetch_assoc($q)): ?>
              <tr>
                <td><?php echo $row['report_date']; ?></td>
                <td><?php echo htmlspecialchars($row['name']); ?></td>
                <td><span class="badge bg-primary"><?php echo ucfirst($row['shift']); ?></span></td>
                <td><span class="badge bg-secondary"><?php echo ucfirst($row['task_type']); ?></span></td>
                <td><?php echo htmlspecialchars($row['client_name']); ?></td>
                <td><?php echo htmlspecialchars($row['ticket_id']); ?></td>
                <td><?php echo nl2br(htmlspecialchars($row['description'])); ?></td>
                <td><?php echo htmlspecialchars($row['time_spent']); ?></td>
                <td class="text-nowrap"><?php echo $row['created_at']; ?></td>
              </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      </div>

    </div>
  </div>
</div>

</body>
</html>
