<?php
session_start();

$host = 'localhost';
$user = 'root';      // REPLACE WITH YOUR DB USER
$pass = '';          // REPLACE WITH YOUR DB PASSWORD
$dbname = 'dailyshiftreport'; // REPLACE WITH YOUR DB NAME

$conn = mysqli_connect($host, $user, $pass, $dbname);

if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

function checkAuth() {
    if (!isset($_SESSION['user'])) {
        header("Location: ../auth/login.php");
        exit;
    }
}

function checkRole($role) {
    if ($_SESSION['user']['role'] !== $role) {
        if ($_SESSION['user']['role'] === 'admin') {
            header("Location: ../admin/dashboard.php");
        } else {
            header("Location: ../employee/dashboard.php");
        }
        exit;
    }
}

function parseTimeToSeconds($str) {
    if (!$str) return 0;
    $str = strtolower(trim($str));
    $seconds = 0;
    if (strpos($str, ':') !== false) {
        $parts = explode(':', $str);
        $h = isset($parts[0]) ? (int)$parts[0] : 0;
        $m = isset($parts[1]) ? (int)$parts[1] : 0;
        $s = isset($parts[2]) ? (int)$parts[2] : 0;
        return ($h * 3600) + ($m * 60) + $s;
    }
    if (preg_match('/(\d+)\s*h/', $str, $matches)) {
        $seconds += (int)$matches[1] * 3600;
    }
    if (preg_match('/(\d+)\s*m/', $str, $matches)) {
        $seconds += (int)$matches[1] * 60;
    }
    if (is_numeric($str)) {
        $seconds += (int)$str * 60;
    }
    return $seconds;
}

function secondsToTime($seconds) {
    $h = floor($seconds / 3600);
    $m = floor(($seconds % 3600) / 60);
    $s = $seconds % 60;
    return sprintf('%02d:%02d:%02d', $h, $m, $s);
}
?>
